/*
 * @(#)OMCommentLinkFigure.java  1.0  2. Februar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.diagram;

import ch.hslu.cm.*;
import ch.hslu.cm.oo.*;
import ch.hslu.cm.simulation.*;
import ch.hslu.cm.oo.objectmodel.*;
import java.util.*;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.handle.Handle;
/**
 * OMCommentLinkFigure visually links a Figure to another Figure which comments
 * on it.
 *
 * @author  Werner Randelshofer
 * @version 1.0 2. Februar 2004  Created.
 */
public class OMCommentLinkFigure extends LineConnectionFigure {
    private OMDependency model;
    
    /** Creates a new instance. */
    public OMCommentLinkFigure() {
        STROKE_DASHES.set(this, new double[] {4d, 4d});
        
        setAttributeEnabled(END_DECORATION, false);
        setAttributeEnabled(START_DECORATION, false);
        setAttributeEnabled(STROKE_DASHES, false);
    }
    
    private Diagram getDiagram() {
        return (Diagram) getDrawing();
    }
    private Simulation getSimulation() {
        return (getDiagram() == null) ? null : getDiagram().getSimulation();
    }
    
    public Collection<Handle> createHandles() {
        return Collections.emptyList();
    }
    
    public SimulatedElement getSimulatedElement() {
        return null;
    }
    public void handleDoubleClick(int x, int y) {
        // empty
    }
    
    /**
     * Checks if two figures can be connected. Implement this method
     * to constrain the allowed connections between figures.
     */
    public boolean canConnect(Figure start, Figure end) {
        return 
        (getStartFigure() == null || start == getStartFigure())
        && (getEndFigure() == null || end == getEndFigure());
    }
    public boolean canConnect(Figure start) {
        return getStartFigure() == null;
    }
    
    public int getConnectionCount() {
        return 0;
    }
    
    public int getConnectionIndex(ConnectionFigure f) {
        return 0;
    }
    
    public int getConnectionIndex(DiagramFigure f) {
        return 0;
    }
    @Override
    public int getLayer() {
        return ClassDiagram.CLASS_LAYER;
    }
}
